#include <bits/stdc++.h>

using namespace std;

const int MAX_N = 200100;

int n,q;
int niz[MAX_N];

struct Node
{
    int value;
    int leftMost, rightMost;
    Node *left, *right;

    Node(int l, int r) : leftMost(l), rightMost(r), left(nullptr), right(nullptr) {}
};

Node* buildTree(int l, int r)
{
    Node* node = new Node(niz[l], niz[r]);

    if(l == r)
    {
        node->value = 0;
        return node;
    }

    int mid = l + (r - l) / 2;
    node->left = buildTree(l, mid);
    node->right = buildTree(mid + 1, r);
    node->value = node->left->value + node->right->value;
    if(node->left->rightMost + 1 != node->right->leftMost)
    {
        node->value = node->value +1;
    }

    return node;
}

void printTree(Node* root, int depth = 0)
{
    if (!root) return;

    printTree(root->right, depth + 1);

    cout << string(depth * 4, ' ') << "[" << root->leftMost << ", " << root->rightMost <<", " << root-> value << "]\n";

    printTree(root->left, depth + 1);
}

int main()
{
    // Ulaz
    cin>>n;
    cin>>q;
    for(int i=0;i<n;i++)
    {
        cin>>niz[i];
    }
    Node* root = buildTree(0, n - 1);
    cout<<root->value<<endl;

    //Obrada
    for(int i=0;i<q;i++)
    {
        int l,r;
        cin>>l>>r;

        int temp = niz[l-1];
        niz[l-1] = niz[r-1];
        niz[r-1] = temp;

        //update
        root = buildTree(0, n - 1);

        cout<<root->value<<endl;
    }
    return 0;
}